
package com.ociweb.auth.login;

import com.ociweb.auth.login.InvalidPasswordException;
import com.ociweb.auth.login.InvalidUserNameException;

import javax.security.auth.login.LoginException;
import java.sql.*;

/**
 * Used by the DatabaseLoginModule to authenticate against a database.
 *
 * @author Brian M. Coyner
 */
public class Authenticator {

    private String sql;
    private String dbDriver;
    private String dbURL;

    /**
     * @param dbDriver the full class name of the DB Driver.
     * @param dbURL a valid URL that points to an existing database.
     * @param sql the SQL to execute to authenticate a user.
     */
    public Authenticator(String dbDriver, String dbURL, String sql) {
        this.dbDriver = dbDriver;
        this.dbURL = dbURL;
        this.sql = sql;
    }

    public void authenticate(String username, String password) throws LoginException {

        Connection conn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;

        try {
            conn = getConnection(this.dbDriver, this.dbURL);
            pStmt = conn.prepareStatement(this.sql);
            pStmt.setString(1, username);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                if (!password.equals(rs.getString(1))) {
                    throw new InvalidPasswordException();
                }
            } else {
                throw new InvalidUserNameException(username);
            }
        } catch (SQLException sqle) {
            throw new LoginException(sqle.getMessage());
        } catch (ClassNotFoundException cnfe) {
            throw new LoginException(cnfe.getMessage());
        } finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                } catch (SQLException ignore) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException ignore) {
                }
            }
        }
    }

    private static Connection getConnection(String dbDriver, String dbURL)
            throws ClassNotFoundException, SQLException {

        Class.forName(dbDriver);
        return DriverManager.getConnection(dbURL);
    }
}
