
package com.ociweb.auth.login;

import javax.security.auth.login.FailedLoginException;

/**
 * @author Brian M. Coyner
 */
public class InvalidUserNameException extends FailedLoginException {

    private String username;

    /**
     * @param username the invalid username.
     */
    public InvalidUserNameException(String username) {
        super("Invalid User Name: " + username);

        this.username = username;
    }

    /**
     * @return the invalid user name.
     */
    public String getUsername() {
        return this.username;
    }
}
