
package com.ociweb.client.unittest;

import com.ociweb.ejb.CatalogMgr;
import com.ociweb.ejb.CatalogMgrHome;

import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

/**
 * @author Brian M. Coyner
 */
public class UT_CatalogMgr extends AbstractLoginTest {

    public UT_CatalogMgr(String name) throws Exception {
        super(name);
    }

    public void testValidInventoryAccess() throws Exception {
        LoginContext lc = getLoginContext("Eric", "secret");
        lc.login();
        try {
            CatalogMgr mgr = getCatalogMgr();
            mgr.getCurrentQuantity("12345");
        } finally {
            lc.logout();
        }
    }

    public void testInvalidInventoryAccess() throws Throwable {
        LoginContext lc = getLoginContext("Brian", "secret");
        lc.login();
        try {
            CatalogMgr mgr = getCatalogMgr();
            mgr.getCurrentQuantity("12345");
            fail("User 'brian' should not have suffecient Role access.");
        } catch (Exception e) {
            assertRootCauseIsLoginException(e);
        } finally {
            lc.logout();
        }
    }

    public void testValidMakePurchaseAccess() throws Exception {
        LoginContext lc = getLoginContext("Karen", "secret");
        lc.login();
        try {
            CatalogMgr mgr = getCatalogMgr();
            mgr.findItem("12345");
            mgr.purchaseItem("12345");
        } finally {
            lc.logout();
        }
    }

    public void testConcurrentCatalogAccess() throws Throwable {
        ThreadHelper tHelper = new ThreadHelper();

        tHelper.addRunnable(new Runnable() {
            public void run() {
                LoginContext lc = null;
                try {
                    lc = getLoginContext("Eric", "secret");
                    lc.login();
                    CatalogMgr mgr = getCatalogMgr();
                    mgr.getCurrentQuantity("12345");
                } catch (Exception e) {
                    fail(e.getMessage());
                } finally {
                    logout(lc);
                }
            }
        });

        tHelper.addRunnable(new Runnable() {
            public void run() {
                LoginContext lc = null;
                try {
                    lc = getLoginContext("Karen", "secret");
                    lc.login();
                    CatalogMgr mgr = getCatalogMgr();
                    mgr.purchaseItem("12345");
                } catch (Exception e) {
                    fail(e.getMessage());
                } finally {
                    logout(lc);
                }
            }
        });

        tHelper.addRunnable(new Runnable() {
            public void run() {
                LoginContext lc = null;
                try {
                    lc = getLoginContext("Chuck", "secret");
                    lc.login();
                    CatalogMgr mgr = getCatalogMgr();
                    mgr.getCurrentQuantity("12345");
                    fail("User 'chuck' should not have suffecient Role access.");
                } catch (Exception e) {
                    try {
                        assertRootCauseIsLoginException(e);
                    } catch (Throwable t) {
                        fail(t.getMessage());
                    }
                } finally {
                    logout(lc);
                }
            }
        });

        tHelper.invokeAllAndWait();
    }

    private CatalogMgr getCatalogMgr() throws Exception {
        Object obj = this.context.lookup("ejb/CatalogMgrHome");
        CatalogMgrHome home =
                (CatalogMgrHome) PortableRemoteObject.narrow(obj, CatalogMgrHome.class);
        return home.create();
    }

    private void logout(LoginContext lc) {
        if (lc != null) {
            try {
                lc.logout();
            } catch (LoginException le) {
                fail(le.getMessage());
            }
        }
    }
}
