
package com.ociweb.auth.login;

import javax.security.auth.callback.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * This CallbackHandler uses the command line to solicit user information.
 *
 * @author Brian M. Coyner
 */
public class ConsoleCallbackHandler implements CallbackHandler {

    /**
     * This method asks the user for their user name and password on the
     * console.  We will see in the GUI example where we give the Callback Handler
     * the user name and password.
     *
     * @param callbacks an array of {@link Callback} objects that are used
     * to handle retrieving user input.
     */
    public void handle(Callback[] callbacks) throws IOException,
                                                    UnsupportedCallbackException {

        // We really know that the first callback is a NameCallback and that
        // the second callback is a PasswordCallback, but I am trying to show
        // how one might handle invalid callbacks
        for (int i = 0; i < callbacks.length; i++) {

            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback) callbacks[i];

                //Ask the user for their user name
                System.out.print(nameCallback.getPrompt());
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                nameCallback.setName(reader.readLine());
            } else if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback) callbacks[i];

                //Ask the user for their password
                System.out.print(passwordCallback.getPrompt());
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String password = reader.readLine();
                passwordCallback.setPassword(password.toCharArray());
            } else {
                throw new UnsupportedCallbackException(callbacks[i],
                        "Unrecognized Callback");
            }
        }
    }
}
