
package com.ociweb.auth.login;

import com.ociweb.auth.login.OCIPrincipal;
import com.ociweb.auth.login.Authenticator;

import javax.security.auth.Subject;
import javax.security.auth.callback.*;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;

/**
 * @author Brian M. Coyner
 */
public class DatabaseLoginModule implements LoginModule {

    private Subject subject;
    private Principal principal;
    private CallbackHandler callbackHandler;
    private Map options;
    private boolean succeeded;
    private String username;
    private char[] password;

    public void initialize(Subject subject,
                           CallbackHandler callbackHandler,
                           Map sharedState,
                           Map options) {

        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.succeeded = false;
    }

    public boolean login() throws LoginException {

        // We need to setup two Callbacks.
        //    1.) to handle user name
        //    2.) to handle password
        //
        // We will use the NameCallback and PasswordCallback that are given
        // to us by Sun.
        Callback[] callbacks = new Callback[2];
        callbacks[0] = new NameCallback("not used");
        callbacks[1] = new PasswordCallback("not used", false);

        try {
            this.callbackHandler.handle(callbacks);
        } catch (IOException ioe) {
            throw new LoginException("Failure to retrieve user input: " +
                                     ioe.getMessage());
        } catch (UnsupportedCallbackException uce) {
            throw new LoginException("Programmer Error! Callback not supported: " +
                                     uce.getMessage());
        }

        this.username = ((NameCallback) callbacks[0]).getName();
        this.password = ((PasswordCallback) callbacks[1]).getPassword();

        //validate username and password by going to a helper DB class.
        Authenticator auth = new Authenticator((String) this.options.get("dbDriver"),
                                               (String) this.options.get("dbURL"),
                                               (String) this.options.get("passwordQuery"));
        auth.authenticate(this.username, new String(this.password));
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded) {
            this.principal = new OCIPrincipal(this.username);
            this.subject.getPrincipals().add(this.principal);
            cleanUp();
            return true;
        } else {
            return false;
        }
    }

    public boolean abort() throws LoginException {
        cleanUp();
        return false;
    }

    public boolean logout() throws LoginException {
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
        }

        this.principal = null;
        return false;
    }

    /**
     * Cleans up the user name and password from memory.
     */
    private void cleanUp() {
        this.username = null;

        for (int i = 0; i < this.password.length; i++) {
            this.password[i] = ' ';
        }
        this.password = null;
    }
}
