
package com.ociweb.auth.login;

import java.io.Serializable;
import java.security.Principal;

/**
 * @author Brian M. Coyner
 */
public class OCIPrincipal implements Principal, Serializable {

    private String username;

    /**
     * @param username the user name of the person who was successfully logged in.
     */
    public OCIPrincipal(String username) {
        this.username = username;
    }

    /**
     * @return the user name of this Principal object.
     */
    public String getName() {
        return this.username;
    }

    /**
     * @return true if and only if the given object is an
     * <code>OCIPrincipal</code> and their usernames are the same.
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof OCIPrincipal)) {
            return false;
        }

        if (obj == this) {
            return true;
        }

        OCIPrincipal rhs = (OCIPrincipal) obj;
        if (this.username.equals(rhs.username)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @return the hash code for this principal object.
     */
    public int hashCode() {
        return this.username == null ? 0 : this.username.hashCode();
    }

    public String toString() {
        return this.username;
    }
}
