
package com.ociweb.auth.login;

import javax.security.auth.callback.*;
import java.io.IOException;

/**
 * This class wraps a user name and password.  Once the <code>handle()</code>
 * method is invoked the user name and password are then set to the
 * appropriate callbacks.  This type of Callback Handler is useful for
 * collecting information from a source before any JAAS-type objects are used.
 *  For example, you could use this class to encapsulate user name and
 * password information for Unit Tests or integrating with a GUI.
 * This allows for authentication information to be known before the
 * callbacks are invoked.
 *
 * @author Brian M. Coyner
 */
public class SimpleCallbackHandler implements CallbackHandler {

    private String username;
    private char[] password;

    public SimpleCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public void handle(Callback[] callbacks) throws IOException,
            UnsupportedCallbackException {

        // We really know that the first callback is a NameCallback and that
        // the second callback is a PasswordCallback, but I am trying to show
        // how one might handle invalid callbacks
        for (int i=0; i<callbacks.length; i++) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback) callbacks[i];
                nameCallback.setName(this.username);
            } else if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback) callbacks[i];
                passwordCallback.setPassword(this.password);
            } else {
                throw new UnsupportedCallbackException(callbacks[i],
                        "Unrecognized Callback");
            }
        }
    }
}
