
package com.ociweb.client.unittest;

import junit.framework.TestCase;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import java.security.Principal;

import org.jboss.security.auth.callback.UsernamePasswordHandler;

/**
 * @author Brian M. Coyner
 */
public class AbstractLoginTest extends TestCase {

    protected Context context;

    protected AbstractLoginTest(String name) throws Exception {
        super(name);
        this.context = new InitialContext();
    }

    public void tearDown() throws Exception {
        this.context = null;
    }

    protected LoginContext getLoginContext(String username, String password)
            throws Exception {

        CallbackHandler handler =
                new UsernamePasswordHandler(username, password.toCharArray());
        return new LoginContext("srp", handler);
    }

    protected Principal getPrincipal(Subject subject) {
        return (Principal) subject.getPrincipals().iterator().next();
    }

    protected void assertRootCauseIsLoginException(Throwable t)
            throws Throwable {
        if (!(findRootCause(t) instanceof SecurityException)) {
            throw t;
        }
    }

    protected Throwable findRootCause(Throwable e) {
        Throwable t = e.getCause();
        if (t == null) {
            return e;
        } else {
            return findRootCause(t);
        }
    }
}
