
package com.ociweb.auth.login;

import javax.swing.*;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * @author Brian M. Coyner
 */
public class SwingLogin extends JFrame {

    private JTextField username = new JTextField(15);
    private JPasswordField password = new JPasswordField(15);
    private JButton loginBtn = new JButton();

    public SwingLogin() {
        super("GUI Login Example");

        this.loginBtn.setAction(new LoginAction(this));

        Container pane = getContentPane();
        ((JComponent) pane).setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        pane.add(new JLabel("Please Enter Username and Password"),
                BorderLayout.NORTH);

        //Add the Labels
        GridBagLayout layout = new GridBagLayout();
        JPanel entryPanel = new JPanel(layout);
        GridBagConstraints gbc = layout.getConstraints(entryPanel);
        gbc.gridx = 0;
        gbc.insets.right = 2;
        gbc.insets.top = 2;
        gbc.anchor = GridBagConstraints.CENTER;
        entryPanel.add(new JLabel("Username:"), gbc);
        entryPanel.add(new JLabel("Password:"), gbc);

        //Add the text fields
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.right = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        entryPanel.add(this.username, gbc);
        entryPanel.add(this.password, gbc);

        getContentPane().add(entryPanel, BorderLayout.CENTER);

        //Add the Login Button
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.loginBtn);
        pane.add(buttonPanel, BorderLayout.SOUTH);

        setResizable(false);
        setDefaultCloseOperation(JDialog.EXIT_ON_CLOSE);
        this.username.requestFocus();
        getRootPane().setDefaultButton(this.loginBtn);
        pack();
    }

    public static void main(String[] args) {
        new SwingLogin().setVisible(true);
    }

    /**
     * Handles the login button click.
     */
    private class LoginAction extends AbstractAction {

        private JFrame owner;

        public LoginAction(JFrame owner) {
            super("Login");
            this.owner = owner;
        }

        public void actionPerformed(ActionEvent evt) {
            String name = System.getProperty("com.ociweb.jaas.appname");
            SimpleCallbackHandler handler =
                    new SimpleCallbackHandler(username.getText(),
                                              password.getPassword());
            try {
                LoginContext context = new LoginContext(name, handler);
                context.login();
                JOptionPane.showMessageDialog(this.owner,
                                              "Success",
                                              "Login Successful",
                                              JOptionPane.INFORMATION_MESSAGE);
            } catch (LoginException le) {
                showErrorMessage("Login Failed", le.getMessage());
                username.setText("");
                password.setText("");
                username.requestFocus();
            } catch (Exception ex) {
                showErrorMessage("Login Failed", ex.getMessage());
            }
        }

        private void showErrorMessage(String title, String message) {
            JOptionPane.showMessageDialog(this.owner,
                                          message,
                                          title,
                                          JOptionPane.ERROR_MESSAGE);
        }
    }
}
