
package com.ociweb.client.unittest;

import com.ociweb.ejb.UserMgr;
import com.ociweb.ejb.UserMgrHome;

import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginContext;

/**
 * @author Brian M. Coyner
 */
public class UT_UserMgr extends AbstractLoginTest {

    public UT_UserMgr(String name) throws Exception {
        super(name);
    }

    public void testValidUserStatisticsAccess() throws Exception {
        LoginContext lc = getLoginContext("Eric", "secret");
        lc.login();
        try {
            UserMgr mgr = getUserMgr();
            mgr.getDemographicInfo();
            mgr.getPurchasingHistory(-1);
        } finally {
            lc.logout();
        }
    }

    public void testInvalidUserStatisticsAccess() throws Throwable {
        LoginContext lc = getLoginContext("Bob", "secret");
        lc.login();
        try {
            UserMgr mgr = getUserMgr();
            mgr.getDemographicInfo();
            fail("User 'bob' should not have suffecient Role access.");
        } catch (Exception e) {
            assertRootCauseIsLoginException(e);
        } finally {
            lc.logout();
        }
    }

    public void testValidUserManagementAccess() throws Exception {
        LoginContext lc = getLoginContext("Suzy", "secret");
        lc.login();
        try {
            UserMgr mgr = getUserMgr();
            //doesn't actually do anything. ;-)
            mgr.updateUser(1, "suzy-q", "secret-pw");
            mgr.findUser(1);
        } finally {
            lc.logout();
        }
    }

    public void testInvalidUserManagementAccess() throws Throwable {
        LoginContext lc = getLoginContext("Chuck", "secret");
        lc.login();
        try {
            UserMgr mgr = getUserMgr();
            mgr.updateUser(1, "chuck-ee", "secret-pw");
        } catch (Exception e) {
            assertRootCauseIsLoginException(e);
        } finally {
            lc.logout();
        }
    }

    private UserMgr getUserMgr() throws Exception {
        Object obj = this.context.lookup("ejb/UserMgrHome");
        UserMgrHome home =
                (UserMgrHome) PortableRemoteObject.narrow(obj, UserMgrHome.class);
        return home.create();
    }
}
