
package com.ociweb.jmx.jaas.srp;

import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.ServiceMBeanSupport;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.Name;

/**
 * @author Brian M. Coyner
 */
public class SRPDatabaseVerifierStoreService extends ServiceMBeanSupport
    implements SRPDatabaseVerifierStoreServiceMBean {

    private DatabaseVerifierStore dbStore;
    private String jndiName;
    private String dsJndiName;
    private String query;

    public SRPDatabaseVerifierStoreService() {
    }

    public void setDsJndiName(String dsJndiName) {
        this.dsJndiName = dsJndiName;
    }

    public String getDsJndiName() {
        return this.dsJndiName;
    }

    public void setPasswordQuery(String query) {
        this.query = query;
    }

    public String getPasswordQuery() {
        return this.query;
    }

    public String getName() {
        return "SRPDatabaseVerifierStoreService";
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void addNewUser(String username, String password) throws Exception {
        this.dbStore.addNewUser(username, password);
    }

    public void deleteUser(String username) {
    }

    public void startService() throws Exception {
        Context context = new InitialContext();

        this.dbStore = new DatabaseVerifierStore(this.dsJndiName, this.query);
        Name name = context.getNameParser("").parse(this.jndiName);
        NonSerializableFactory.rebind(name, this.dbStore, true);
    }
}
