CREATE DATABASE IF NOT EXISTS security;

USE security;

DROP TABLE IF EXISTS UserGroups;
DROP TABLE IF EXISTS GroupRoles;
DROP TABLE IF EXISTS Users;
DROP TABLE IF EXISTS Groups;
DROP TABLE IF EXISTS Roles;

CREATE TABLE Users
  (id         INT         NOT NULL PRIMARY KEY,
   username   VARCHAR(15) NOT NULL,
   password   VARCHAR(15) NOT NULL);

CREATE TABLE Groups
  (id          DOUBLE       NOT NULL PRIMARY KEY,
   name        VARCHAR(30)  NOT NULL,
   description VARCHAR(100) NOT NULL);

CREATE TABLE Roles
  (id          DOUBLE       NOT NULL PRIMARY KEY,
   name        VARCHAR(30)  NOT NULL,
   description VARCHAR(100) NOT NULL);

CREATE TABLE UserGroups
  (userID  DOUBLE NOT NULL,
   groupID DOUBLE NOT NULL);

CREATE TABLE GroupRoles
  (groupID DOUBLE NOT NULL,
   roleID  DOUBLE NOT NULL);

INSERT INTO Users (id, username, password)
     VALUES (1, 'Brian', 'secret');
INSERT INTO Users (id, username, password)
     VALUES (2, 'Eric', 'secret');
INSERT INTO Users (id, username, password)
     VALUES (3, 'Chuck', 'secret');
INSERT INTO Users (id, username, password)
     VALUES (4, 'Karen', 'secret');
INSERT INTO Users (id, username, password)
     VALUES (5, 'Bob', 'secret');
INSERT INTO Users (id, username, password)
     VALUES (6, 'Suzy', 'secret');

INSERT INTO Groups (id, name, description)
     VALUES (100, 'Administrator', 'Able to manage the system resources.');
INSERT INTO Groups (id, name, description)
     VALUES (101, 'Manager', 'Has Power to Modify and View critical data.');
INSERT INTO Groups (id, name, description)
     VALUES (102, 'Customer', 'Able to browse and purchase items.');

INSERT INTO Roles (id, name, description)
     VALUES (200, 'ViewInventoryLevels', 'View private inventory count.');
INSERT INTO Roles (id, name, description)
     VALUES (201, 'ViewUserStatistics', 'View statistics on users.');
INSERT INTO Roles (id, name, description)
     VALUES (202, 'SearchCatalog', 'Ability to view online catalog.');
INSERT INTO Roles (id, name, description)
     VALUES (203, 'PurchaseItem', 'Ability to buy an item(s).');
INSERT INTO Roles (id, name, description)
     VALUES (204, 'ManageUsers', 'Manage Users and Roles.');
INSERT INTO Roles (id, name, description)
     VALUES (205, 'UpdateCustomer', 'Update Customer information.');

INSERT INTO UserGroups VALUES (1, 100);
INSERT INTO UserGroups VALUES (1, 102);
INSERT INTO UserGroups VALUES (2, 101);
INSERT INTO UserGroups VALUES (2, 102);
INSERT INTO UserGroups VALUES (3, 102);
INSERT INTO UserGroups VALUES (4, 102);
INSERT INTO UserGroups VALUES (5, 102);
INSERT INTO UserGroups VALUES (6, 100);
INSERT INTO UserGroups VALUES (6, 102);
INSERT INTO UserGroups VALUES (7, 101);
INSERT INTO UserGroups VALUES (7, 102);

INSERT INTO GroupRoles VALUES (100, 204);
INSERT INTO GroupRoles VALUES (100, 205);
INSERT INTO GroupRoles VALUES (101, 200);
INSERT INTO GroupRoles VALUES (101, 201);
INSERT INTO GroupRoles VALUES (102, 202);
INSERT INTO GroupRoles VALUES (102, 203);