
package com.ociweb.client.unittest;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author Brian M. Coyner
 */
public class ThreadHelper {

    private ThreadGroup group;
    private List threads;

    public ThreadHelper() {
        this.group = new ThreadGroup("ThreadHelper");
        this.threads = new ArrayList();
    }

    public void addRunnable(Runnable runnable) {
        this.threads.add(new Thread(this.group, runnable));
    }

    public void invokeAllAndWait() {
        Iterator iter = this.threads.iterator();
        while (iter.hasNext()) {
            ((Thread) iter.next()).start();
        }

        while (this.group.activeCount() != 0) {
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
            }
        }
    }
}
