
package com.ociweb.client.unittest;

import org.jboss.security.auth.callback.UsernamePasswordHandler;

import javax.security.auth.login.LoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import java.security.Principal;

/**
 * @author Brian M. Coyner
 */
public class UT_Login extends AbstractLoginTest {

    public UT_Login(String name) throws Exception {
        super(name);
    }

    public void testSingleLogin() throws Exception {
        LoginContext lc = getLoginContext("Brian", "secret");
        lc.login();
        Subject subject = lc.getSubject();
        assertNotNull("Subject.", subject);
        Principal p = getPrincipal(subject);
        assertEquals("Principal Name.", "Brian", p.getName());
        lc.logout();
    }

    public void testInvalidUsername() throws Exception {
        try {
            LoginContext lc = getLoginContext("BAD_USERNAME", "secret");
            lc.login();
            fail("Login should have failed due to invalid username");
        } catch (LoginException ignore) {
        }
    }

    public void testInvalidUserAndPassword() throws Exception {
        try {
            LoginContext lc = getLoginContext("BAD_USERNAME", "BAD_PW");
            lc.login();
            fail("Login should have failed due to invalid username and password");
        } catch (LoginException ignore) {
        }
    }

    public void testInvalidPassword() throws Exception {
        try {
            LoginContext lc = getLoginContext("Brian", "BAD_PW");
            lc.login();
            fail("Login should have failed due to invalid password");
        } catch (LoginException ignore) {
        }
    }


    public void testTwoThreads() {

        ThreadHelper helper = new ThreadHelper();
        helper.addRunnable(new Runnable() {
            public void run() {
                try {
                    CallbackHandler handler = new UsernamePasswordHandler(
                            "Chuck", "secret".toCharArray());
                    LoginContext lc = new LoginContext("srp", handler);
                    lc.login();
                    Subject subject = lc.getSubject();
                    Principal principal = (Principal) subject.getPrincipals().
                            iterator().next();
                    assertEquals("Principal Name should be 'Chuck'.  " +
                                 "Make sure the " +
                                 "org.jboss.security.ClientLoginModule is " +
                                 "set to support multithreading " +
                                 "(multi-threaded=true) in your client " +
                                 "auth.conf file.",
                                 "Chuck",
                                 principal.getName());
                    lc.logout();
                } catch (Exception e) {
                    fail("Chuck login failed." + e.getMessage());
                }
            }
        });

        helper.addRunnable(new Runnable() {
            public void run() {
                try {
                    CallbackHandler handler = new UsernamePasswordHandler(
                            "Brian", "secret".toCharArray());
                    LoginContext lc = new LoginContext("srp", handler);
                    lc.login();
                    Subject subject = lc.getSubject();
                    Principal principal = (Principal) subject.getPrincipals().
                            iterator().next();
                    assertEquals("Principal Name should be 'Brian'.  " +
                                 "Make sure the " +
                                 "org.jboss.security.ClientLoginModule is " +
                                 "set to support multithreading " +
                                 "(multi-threaded=true) in your client " +
                                 "auth.conf file.",
                                 "Brian",
                                 principal.getName());
                    lc.logout();
                } catch (Exception e) {
                    fail("Brian login failed. " + e.getMessage());
                }
            }
        });

        helper.invokeAllAndWait();
    }
}
