/*
 * Decompiled with CFR 0.152.
 */
package eg.music;

import eg.music.Music;
import eg.music.MusicPlayer;
import eg.music.Simulator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class MusicLibrary {
    static Music looking = null;
    static Music[] library = new Music[0];

    static void load(String string) throws Exception {
        ArrayList<Music> arrayList = new ArrayList<Music>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        bufferedReader.readLine();
        while (bufferedReader.ready()) {
            arrayList.add(Music.parse(bufferedReader.readLine()));
        }
        bufferedReader.close();
        library = arrayList.toArray(library);
    }

    static void select(Music music) {
        looking = music;
    }

    static void search(double d) {
        Music.status = "searching";
        Simulator.nextSearchComplete = Simulator.schedule(d);
    }

    static void searchComplete() {
        Music.status = MusicPlayer.playing == null ? "ready" : "playing";
    }

    static void findAll() {
        MusicLibrary.search(3.2);
        for (int i = 0; i < library.length; ++i) {
            MusicLibrary.library[i].selected = true;
        }
    }

    static void findArtist(String string) {
        MusicLibrary.search(2.3);
        for (int i = 0; i < library.length; ++i) {
            MusicLibrary.library[i].selected = MusicLibrary.library[i].artist.equals(string);
        }
    }

    static void findAlbum(String string) {
        MusicLibrary.search(1.1);
        for (int i = 0; i < library.length; ++i) {
            MusicLibrary.library[i].selected = MusicLibrary.library[i].album.equals(string);
        }
    }

    static void findGenre(String string) {
        MusicLibrary.search(0.2);
        for (int i = 0; i < library.length; ++i) {
            MusicLibrary.library[i].selected = MusicLibrary.library[i].genre.equals(string);
        }
    }

    static void findYear(int n) {
        MusicLibrary.search(0.8);
        for (int i = 0; i < library.length; ++i) {
            MusicLibrary.library[i].selected = MusicLibrary.library[i].year == n;
        }
    }

    static int displayCount() {
        int n = 0;
        for (int i = 0; i < library.length; ++i) {
            n += MusicLibrary.library[i].selected ? 1 : 0;
        }
        return n;
    }

    static Music[] displayContents() {
        Music[] musicArray = new Music[MusicLibrary.displayCount()];
        int n = 0;
        for (int i = 0; i < library.length; ++i) {
            if (!MusicLibrary.library[i].selected) continue;
            musicArray[n++] = library[i];
        }
        return musicArray;
    }
}

