/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.ColumnFixture;
import fit.Fixture;
import fit.Parse;
import fit.ScientificDouble;
import fit.TypeAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class FrameworkTest
extends TestCase {
    public FrameworkTest(String string) {
        super(string);
    }

    public void testTypeAdapter() throws Exception {
        TestFixture testFixture = new TestFixture();
        TypeAdapter typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleInt"));
        typeAdapter.set(typeAdapter.parse("123456"));
        FrameworkTest.assertEquals((int)123456, (int)testFixture.sampleInt);
        FrameworkTest.assertEquals((String)"-234567", (String)typeAdapter.parse("-234567").toString());
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleInteger"));
        typeAdapter.set(typeAdapter.parse("54321"));
        FrameworkTest.assertEquals((String)"54321", (String)testFixture.sampleInteger.toString());
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getMethod("pi", new Class[0]));
        FrameworkTest.assertEquals((double)3.14159, (double)((Double)typeAdapter.invoke()), (double)1.0E-5);
        FrameworkTest.assertEquals((Object)new Double(3.14159862), (Object)typeAdapter.invoke());
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("ch"));
        typeAdapter.set(typeAdapter.parse("abc"));
        FrameworkTest.assertEquals((char)'a', (char)testFixture.ch);
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("name"));
        typeAdapter.set(typeAdapter.parse("xyzzy"));
        FrameworkTest.assertEquals((String)"xyzzy", (String)testFixture.name);
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleFloat"));
        typeAdapter.set(typeAdapter.parse("6.02e23"));
        FrameworkTest.assertEquals((double)6.02E23, (double)testFixture.sampleFloat, (double)1.0E17);
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleArray"));
        typeAdapter.set(typeAdapter.parse("1,2,3"));
        FrameworkTest.assertEquals((int)1, (int)testFixture.sampleArray[0]);
        FrameworkTest.assertEquals((int)2, (int)testFixture.sampleArray[1]);
        FrameworkTest.assertEquals((int)3, (int)testFixture.sampleArray[2]);
        FrameworkTest.assertEquals((String)"1, 2, 3", (String)typeAdapter.toString(testFixture.sampleArray));
        FrameworkTest.assertTrue((boolean)typeAdapter.equals(new int[]{1, 2, 3}, testFixture.sampleArray));
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleDate"));
        Date date = new GregorianCalendar(1949, 4, 26).getTime();
        typeAdapter.set(typeAdapter.parse(DateFormat.getDateInstance().format(date)));
        FrameworkTest.assertEquals((Object)date, (Object)testFixture.sampleDate);
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleByte"));
        typeAdapter.set(typeAdapter.parse("123"));
        FrameworkTest.assertEquals((int)123, (int)testFixture.sampleByte);
        typeAdapter = TypeAdapter.on((Fixture)testFixture, testFixture.getClass().getField("sampleShort"));
        typeAdapter.set(typeAdapter.parse("12345"));
        FrameworkTest.assertEquals((int)12345, (int)testFixture.sampleShort);
    }

    public void testScientificDouble() {
        Double d = new Double(3.141592865);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("3.14"), (Object)d);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("3.142"), (Object)d);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("3.1416"), (Object)d);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("3.14159"), (Object)d);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("3.141592865"), (Object)d);
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("3.140").equals(d) ? 1 : 0) != 0);
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("3.144").equals(d) ? 1 : 0) != 0);
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("3.1414").equals(d) ? 1 : 0) != 0);
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("3.141592863").equals(d) ? 1 : 0) != 0);
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("6.02e23"), (Object)new Double(6.02E23));
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("6.02E23"), (Object)new Double(6.024E23));
        FrameworkTest.assertEquals((Object)ScientificDouble.valueOf("6.02e23"), (Object)new Double(6.016E23));
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("6.02e23").equals(new Double(6.026E23)) ? 1 : 0) != 0);
        FrameworkTest.assertTrue((!ScientificDouble.valueOf("6.02e23").equals(new Double(6.014E23)) ? 1 : 0) != 0);
    }

    public void testEscape() {
        String string = "!@#$%^*()_-+={}|[]\\:\";',./?`";
        FrameworkTest.assertEquals((String)string, (String)Fixture.escape(string));
        FrameworkTest.assertEquals((String)"", (String)Fixture.escape(""));
        FrameworkTest.assertEquals((String)"&lt;", (String)Fixture.escape("<"));
        FrameworkTest.assertEquals((String)"&lt;&lt;", (String)Fixture.escape("<<"));
        FrameworkTest.assertEquals((String)"x&lt;", (String)Fixture.escape("x<"));
        FrameworkTest.assertEquals((String)"&amp;", (String)Fixture.escape("&"));
        FrameworkTest.assertEquals((String)"&lt;&amp;&lt;", (String)Fixture.escape("<&<"));
        FrameworkTest.assertEquals((String)"&amp;&lt;&amp;", (String)Fixture.escape("&<&"));
        FrameworkTest.assertEquals((String)"a &lt; b &amp;&amp; c &lt; d", (String)Fixture.escape("a < b && c < d"));
        FrameworkTest.assertEquals((String)"a<br />b", (String)Fixture.escape("a\nb"));
    }

    public void testRuns() throws Exception {
        this.run("arithmetic", 37, 10, 0, 2);
        this.run("CalculatorExample", 75, 9, 0, 0);
        this.run("MusicExample", 95, 0, 0, 0);
    }

    protected void run(String string, int n, int n2, int n3, int n4) throws Exception {
        Parse parse;
        String string2 = this.read(new File("../../examples/" + string + ".html"));
        Fixture fixture = new Fixture();
        if (string2.indexOf("<wiki>") >= 0) {
            parse = new Parse(string2, new String[]{"wiki", "table", "tr", "td"});
            fixture.doTables(parse.parts);
        } else {
            parse = new Parse(string2, new String[]{"table", "tr", "td"});
            fixture.doTables(parse);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("output/test/" + string + ".html")));
        parse.print(printWriter);
        printWriter.close();
        FrameworkTest.assertEquals((String)(string + " right"), (int)n, (int)fixture.counts.right);
        FrameworkTest.assertEquals((String)(string + " wrong"), (int)n2, (int)fixture.counts.wrong);
        FrameworkTest.assertEquals((String)(string + " ignores"), (int)n3, (int)fixture.counts.ignores);
        FrameworkTest.assertEquals((String)(string + " excpetions"), (int)n4, (int)fixture.counts.exceptions);
    }

    protected String read(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        return new String(cArray);
    }

    class TestFixture
    extends ColumnFixture {
        public byte sampleByte;
        public short sampleShort;
        public int sampleInt;
        public Integer sampleInteger;
        public float sampleFloat;
        public char ch;
        public String name;
        public int[] sampleArray;
        public Date sampleDate;

        TestFixture() {
        }

        public double pi() {
            return 3.14159862;
        }
    }
}

