/*
 * Decompiled with CFR 0.152.
 */
package eg;

import fit.ColumnFixture;
import fit.Counts;
import fit.Fixture;
import fit.Parse;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AllFiles
extends Fixture {
    public static int runCount = 0;
    public static List fileStack = new ArrayList();

    public void doRow(Parse parse) {
        Parse parse2 = parse.leaf();
        List list = this.expand(parse2.text());
        if (list.size() > 0) {
            this.doRow(parse, list);
        } else {
            this.ignore(parse2);
            this.info(parse2, " no match");
        }
    }

    protected List expand(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        ArrayList arrayList = new ArrayList();
        this.expand(new File("."), stringTokenizer, arrayList);
        return arrayList;
    }

    protected void expand(File file, StringTokenizer stringTokenizer, List list) {
        if (stringTokenizer.hasMoreTokens()) {
            File[] fileArray = file.listFiles(new WildCard(stringTokenizer.nextToken()));
            for (int i = 0; i < fileArray.length; ++i) {
                this.expand(fileArray[i], stringTokenizer, list);
            }
        } else {
            list.add(file);
        }
    }

    protected void doRow(Parse parse, List list) {
        this.doFiles(parse, list);
    }

    protected void doFiles(Parse parse, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Parse parse2 = this.td(file.getName(), this.td("", null));
            parse = parse.more = this.tr(parse2, parse.more);
            Fixture fixture = new Fixture();
            this.run(file, fixture, parse2);
            this.summarize(fixture, file);
        }
    }

    protected void run(File file, Fixture fixture, Parse parse) {
        if (this.pushAndCheck(file)) {
            this.ignore(parse);
            this.info(parse, "recursive");
            return;
        }
        try {
            Parse parse2;
            String string = this.read(file);
            if (string.indexOf("<wiki>") >= 0) {
                parse2 = new Parse(string, new String[]{"wiki", "table", "tr", "td"});
                fixture.doTables(parse2.parts);
            } else {
                parse2 = new Parse(string, new String[]{"table", "tr", "td"});
                fixture.doTables(parse2);
            }
            this.info(parse.more, fixture.counts.toString());
            if (fixture.counts.wrong == 0 && fixture.counts.exceptions == 0) {
                this.right(parse.more);
            } else {
                this.wrong(parse.more);
                parse.more.addToBody(parse2.footnote());
            }
        }
        catch (Exception exception) {
            this.exception(parse, exception);
        }
        this.pop(file);
    }

    protected boolean pushAndCheck(File file) {
        String string = file.getAbsolutePath();
        if (fileStack.contains(string)) {
            return true;
        }
        fileStack.add(string);
        return false;
    }

    protected void pop(File file) {
        fileStack.remove(file.getAbsolutePath());
    }

    private void summarize(Fixture fixture, File file) {
        fixture.summary.put("input file", file.getAbsolutePath());
        fixture.summary.put("input update", new Date(file.lastModified()));
        Counts counts = this.summary.containsKey("counts run") ? (Counts)this.summary.get("counts run") : new Counts();
        counts.tally(fixture.counts);
        this.summary.put("counts run", counts);
    }

    protected String read(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        return new String(cArray);
    }

    Parse tr(Parse parse, Parse parse2) {
        return new Parse("tr", null, parse, parse2);
    }

    Parse td(String string, Parse parse) {
        return new Parse("td", this.info(string), null, parse);
    }

    public static class Expand
    extends ColumnFixture {
        public String path;
        AllFiles fixture = new AllFiles();

        public String[] expansion() {
            List list = this.fixture.expand(this.path);
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((File)list.get(i)).getName();
            }
            return stringArray;
        }
    }

    class WildCard
    implements FilenameFilter {
        String prefix;
        String sufix;
        int minimum;

        WildCard(String string) {
            int n = string.indexOf("*");
            if (n >= 0) {
                this.prefix = string.substring(0, n);
                this.sufix = string.substring(n + 1);
                this.minimum = this.prefix.length() + this.sufix.length();
            } else {
                this.prefix = string;
                this.sufix = null;
                this.minimum = this.prefix.length();
            }
        }

        public boolean accept(File file, String string) {
            return !string.startsWith(".") && string.length() >= this.minimum && string.startsWith(this.prefix) && (this.sufix == null ? string.length() == this.minimum : string.endsWith(this.sufix));
        }
    }
}

