/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class TypeAdapter {
    public Object target;
    public Fixture fixture;
    public Field field;
    public Method method;
    public Class type;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static TypeAdapter on(Fixture fixture, Class clazz) {
        TypeAdapter typeAdapter = TypeAdapter.adapterFor(clazz);
        typeAdapter.init(fixture, clazz);
        return typeAdapter;
    }

    public static TypeAdapter on(Fixture fixture, Field field) {
        TypeAdapter typeAdapter = TypeAdapter.on(fixture, field.getType());
        typeAdapter.target = fixture;
        typeAdapter.field = field;
        return typeAdapter;
    }

    public static TypeAdapter on(Fixture fixture, Method method) {
        TypeAdapter typeAdapter = TypeAdapter.on(fixture, method.getReturnType());
        typeAdapter.target = fixture;
        typeAdapter.method = method;
        return typeAdapter;
    }

    public static TypeAdapter adapterFor(Class clazz) throws UnsupportedOperationException {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return new ByteAdapter();
            }
            if (clazz.equals(Short.TYPE)) {
                return new ShortAdapter();
            }
            if (clazz.equals(Integer.TYPE)) {
                return new IntAdapter();
            }
            if (clazz.equals(Long.TYPE)) {
                return new LongAdapter();
            }
            if (clazz.equals(Float.TYPE)) {
                return new FloatAdapter();
            }
            if (clazz.equals(Double.TYPE)) {
                return new DoubleAdapter();
            }
            if (clazz.equals(Character.TYPE)) {
                return new CharAdapter();
            }
            if (clazz.equals(Boolean.TYPE)) {
                return new BooleanAdapter();
            }
            throw new UnsupportedOperationException("can't yet adapt " + clazz);
        }
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeAdapter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new ClassByteAdapter();
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = TypeAdapter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new ClassShortAdapter();
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeAdapter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new ClassIntegerAdapter();
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = TypeAdapter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new ClassLongAdapter();
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = TypeAdapter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new ClassFloatAdapter();
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = TypeAdapter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new ClassDoubleAdapter();
        }
        if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = TypeAdapter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new ClassCharacterAdapter();
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new ClassBooleanAdapter();
        }
        if (clazz.isArray()) {
            return new ArrayAdapter();
        }
        return new TypeAdapter();
    }

    protected void init(Fixture fixture, Class clazz) {
        this.fixture = fixture;
        this.type = clazz;
    }

    public Object get() throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(this.target);
        }
        if (this.method != null) {
            return this.invoke();
        }
        return null;
    }

    public void set(Object object) throws IllegalAccessException {
        this.field.set(this.target, object);
    }

    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{};
        return this.method.invoke(this.target, objectArray);
    }

    public Object parse(String string) throws Exception {
        return this.fixture.parse(string, this.type);
    }

    public boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ArrayAdapter
    extends TypeAdapter {
        Class componentType;
        TypeAdapter componentAdapter;

        ArrayAdapter() {
        }

        protected void init(Fixture fixture, Class clazz) {
            super.init(fixture, clazz);
            this.componentType = clazz.getComponentType();
            this.componentAdapter = ArrayAdapter.on(fixture, this.componentType);
        }

        public Object parse(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Object object = Array.newInstance(this.componentType, stringTokenizer.countTokens());
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                Array.set(object, n, this.componentAdapter.parse(stringTokenizer.nextToken().trim()));
                ++n;
            }
            return object;
        }

        public String toString(Object object) {
            if (object == null) {
                return "";
            }
            int n = Array.getLength(object);
            StringBuffer stringBuffer = new StringBuffer(5 * n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.componentAdapter.toString(Array.get(object, i)));
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object, Object object2) {
            int n = Array.getLength(object);
            if (n != Array.getLength(object2)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.componentAdapter.equals(Array.get(object, i), Array.get(object2, i))) continue;
                return false;
            }
            return true;
        }
    }

    static class ClassBooleanAdapter
    extends TypeAdapter {
        ClassBooleanAdapter() {
        }

        public Object parse(String string) {
            return new Boolean(string);
        }
    }

    static class BooleanAdapter
    extends ClassBooleanAdapter {
        BooleanAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setBoolean(this.target, (Boolean)object);
        }
    }

    static class ClassCharacterAdapter
    extends TypeAdapter {
        ClassCharacterAdapter() {
        }

        public Object parse(String string) {
            return new Character(string.charAt(0));
        }
    }

    static class CharAdapter
    extends ClassCharacterAdapter {
        CharAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setChar(this.target, ((Character)object).charValue());
        }
    }

    static class ClassDoubleAdapter
    extends TypeAdapter {
        ClassDoubleAdapter() {
        }

        public Object parse(String string) {
            return new Double(Double.parseDouble(string));
        }
    }

    static class DoubleAdapter
    extends ClassDoubleAdapter {
        DoubleAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setDouble(this.target, ((Number)object).doubleValue());
        }

        public Object parse(String string) {
            return new Double(Double.parseDouble(string));
        }
    }

    static class ClassFloatAdapter
    extends TypeAdapter {
        ClassFloatAdapter() {
        }

        public Object parse(String string) {
            return new Float(Float.parseFloat(string));
        }
    }

    static class FloatAdapter
    extends ClassFloatAdapter {
        FloatAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setFloat(this.target, ((Number)object).floatValue());
        }

        public Object parse(String string) {
            return new Float(Float.parseFloat(string));
        }
    }

    static class ClassLongAdapter
    extends TypeAdapter {
        ClassLongAdapter() {
        }

        public Object parse(String string) {
            return new Long(Long.parseLong(string));
        }
    }

    static class LongAdapter
    extends ClassLongAdapter {
        LongAdapter() {
        }

        public void set(Long l) throws IllegalAccessException {
            this.field.setLong(this.target, l);
        }
    }

    static class ClassIntegerAdapter
    extends TypeAdapter {
        ClassIntegerAdapter() {
        }

        public Object parse(String string) {
            return new Integer(Integer.parseInt(string));
        }
    }

    static class IntAdapter
    extends ClassIntegerAdapter {
        IntAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setInt(this.target, (Integer)object);
        }
    }

    static class ClassShortAdapter
    extends TypeAdapter {
        ClassShortAdapter() {
        }

        public Object parse(String string) {
            return new Short(Short.parseShort(string));
        }
    }

    static class ShortAdapter
    extends ClassShortAdapter {
        ShortAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setShort(this.target, (Short)object);
        }
    }

    static class ClassByteAdapter
    extends TypeAdapter {
        ClassByteAdapter() {
        }

        public Object parse(String string) {
            return new Byte(Byte.parseByte(string));
        }
    }

    static class ByteAdapter
    extends ClassByteAdapter {
        ByteAdapter() {
        }

        public void set(Object object) throws IllegalAccessException {
            this.field.setByte(this.target, (Byte)object);
        }
    }
}

