/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class FileRunner {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public PrintWriter output;

    public static void main(String[] stringArray) {
        try {
            new FileRunner().run(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(-1);
        }
    }

    public void run(String[] stringArray) throws IOException {
        this.args(stringArray);
        this.process();
        this.exit();
    }

    public void process() {
        try {
            if (this.input.indexOf("<wiki>") >= 0) {
                this.tables = new Parse(this.input, new String[]{"wiki", "table", "tr", "td"});
                this.fixture.doTables(this.tables.parts);
            } else {
                this.tables = new Parse(this.input, new String[]{"table", "tr", "td"});
                this.fixture.doTables(this.tables);
            }
        }
        catch (Exception exception) {
            this.exception(exception);
        }
        this.tables.print(this.output);
    }

    public void args(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("usage: java fit.FileRunner input-file output-file");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        this.fixture.summary.put("input file", file.getAbsolutePath());
        this.fixture.summary.put("input update", new Date(file.lastModified()));
        this.fixture.summary.put("output file", file2.getAbsolutePath());
        this.input = this.read(file);
        this.output = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
    }

    protected String read(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        return new String(cArray);
    }

    protected void exception(Exception exception) {
        this.tables = new Parse("body", "Unable to parse input. Input ignored.", null, null);
        this.fixture.exception(this.tables, exception);
    }

    protected void exit() {
        this.output.close();
        System.err.println(this.fixture.counts());
        System.exit(this.fixture.counts.wrong + this.fixture.counts.exceptions);
    }
}

