/*
 * Decompiled with CFR 0.152.
 */
package eg.music;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class Music {
    static String status = "ready";
    public String title;
    public String artist;
    public String album;
    public String genre;
    public long size;
    public int seconds;
    public int trackNumber;
    public int trackCount;
    public int year;
    public Date date;
    public transient boolean selected = false;
    static DateFormat dateFormat = new SimpleDateFormat("M/d/yy h:mm a");

    public String track() {
        return this.trackNumber + " of " + this.trackCount;
    }

    public double time() {
        return (double)Math.round((double)this.seconds / 0.6) / 100.0;
    }

    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return super.toString();
    }

    static Music parse(String string) throws ParseException {
        Music music = new Music();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        music.title = stringTokenizer.nextToken();
        music.artist = stringTokenizer.nextToken();
        music.album = stringTokenizer.nextToken();
        music.genre = stringTokenizer.nextToken();
        music.size = Long.parseLong(stringTokenizer.nextToken());
        music.seconds = Integer.parseInt(stringTokenizer.nextToken());
        music.trackNumber = Integer.parseInt(stringTokenizer.nextToken());
        music.trackCount = Integer.parseInt(stringTokenizer.nextToken());
        music.year = Integer.parseInt(stringTokenizer.nextToken());
        music.date = dateFormat.parse(stringTokenizer.nextToken());
        return music;
    }
}

