/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Parse;
import java.text.ParseException;
import junit.framework.TestCase;

public class ParseTest
extends TestCase {
    public ParseTest(String string) {
        super(string);
    }

    public void testParsing() throws Exception {
        Parse parse = new Parse("leader<Table foo=2>body</table>trailer", new String[]{"table"});
        ParseTest.assertEquals((String)"leader", (String)parse.leader);
        ParseTest.assertEquals((String)"<Table foo=2>", (String)parse.tag);
        ParseTest.assertEquals((String)"body", (String)parse.body);
        ParseTest.assertEquals((String)"trailer", (String)parse.trailer);
    }

    public void testRecursing() throws Exception {
        Parse parse = new Parse("leader<table><TR><Td>body</tD></TR></table>trailer");
        ParseTest.assertEquals(null, (String)parse.body);
        ParseTest.assertEquals(null, (String)parse.parts.body);
        ParseTest.assertEquals((String)"body", (String)parse.parts.parts.body);
    }

    public void testIterating() throws Exception {
        Parse parse = new Parse("leader<table><tr><td>one</td><td>two</td><td>three</td></tr></table>trailer");
        ParseTest.assertEquals((String)"one", (String)parse.parts.parts.body);
        ParseTest.assertEquals((String)"two", (String)parse.parts.parts.more.body);
        ParseTest.assertEquals((String)"three", (String)parse.parts.parts.more.more.body);
    }

    public void testIndexing() throws Exception {
        Parse parse = new Parse("leader<table><tr><td>one</td><td>two</td><td>three</td></tr><tr><td>four</td></tr></table>trailer");
        ParseTest.assertEquals((String)"one", (String)parse.at((int)0, (int)0, (int)0).body);
        ParseTest.assertEquals((String)"two", (String)parse.at((int)0, (int)0, (int)1).body);
        ParseTest.assertEquals((String)"three", (String)parse.at((int)0, (int)0, (int)2).body);
        ParseTest.assertEquals((String)"three", (String)parse.at((int)0, (int)0, (int)3).body);
        ParseTest.assertEquals((String)"three", (String)parse.at((int)0, (int)0, (int)4).body);
        ParseTest.assertEquals((String)"four", (String)parse.at((int)0, (int)1, (int)0).body);
        ParseTest.assertEquals((String)"four", (String)parse.at((int)0, (int)1, (int)1).body);
        ParseTest.assertEquals((String)"four", (String)parse.at((int)0, (int)2, (int)0).body);
        ParseTest.assertEquals((int)1, (int)parse.size());
        ParseTest.assertEquals((int)2, (int)parse.parts.size());
        ParseTest.assertEquals((int)3, (int)parse.parts.parts.size());
        ParseTest.assertEquals((String)"one", (String)parse.leaf().body);
        ParseTest.assertEquals((String)"four", (String)parse.parts.last().leaf().body);
    }

    public void testParseException() {
        try {
            Parse parse = new Parse("leader<table><tr><th>one</th><th>two</th><th>three</th></tr><tr><td>four</td></tr></table>trailer");
        }
        catch (ParseException parseException) {
            ParseTest.assertEquals((int)17, (int)parseException.getErrorOffset());
            ParseTest.assertEquals((String)"Can't find tag: td", (String)parseException.getMessage());
            return;
        }
        ParseTest.fail((String)"exptected exception not thrown");
    }

    public void testText() throws Exception {
        String[] stringArray = new String[]{"td"};
        Parse parse = new Parse("<td>a&lt;b</td>", stringArray);
        ParseTest.assertEquals((String)"a&lt;b", (String)parse.body);
        ParseTest.assertEquals((String)"a<b", (String)parse.text());
        parse = new Parse("<td>\ta&gt;b&nbsp;&amp;&nbsp;b>c &&&lt;</td>", stringArray);
        ParseTest.assertEquals((String)"a>b & b>c &&<", (String)parse.text());
        parse = new Parse("<td>\ta&gt;b&nbsp;&amp;&nbsp;b>c &&lt;</td>", stringArray);
        ParseTest.assertEquals((String)"a>b & b>c &<", (String)parse.text());
        parse = new Parse("<TD><P><FONT FACE=\"Arial\" SIZE=2>GroupTestFixture</FONT></TD>", stringArray);
        ParseTest.assertEquals((String)"GroupTestFixture", (String)parse.text());
        ParseTest.assertEquals((String)"", (String)Parse.htmlToText("&nbsp;"));
        ParseTest.assertEquals((String)"a b", (String)Parse.htmlToText("a <tag /> b"));
        ParseTest.assertEquals((String)"a", (String)Parse.htmlToText("a &nbsp;"));
        ParseTest.assertEquals((String)"&nbsp;", (String)Parse.htmlToText("&amp;nbsp;"));
        ParseTest.assertEquals((String)"1     2", (String)Parse.htmlToText("1 &nbsp; &nbsp; 2"));
        ParseTest.assertEquals((String)"1     2", (String)Parse.htmlToText("1 \u00a0\u00a0\u00a0\u00a02"));
        ParseTest.assertEquals((String)"a", (String)Parse.htmlToText("  <tag />a"));
        ParseTest.assertEquals((String)"a\nb", (String)Parse.htmlToText("a<br />b"));
        ParseTest.assertEquals((String)"ab", (String)Parse.htmlToText("<font size=+1>a</font>b"));
        ParseTest.assertEquals((String)"ab", (String)Parse.htmlToText("a<font size=+1>b</font>"));
        ParseTest.assertEquals((String)"a<b", (String)Parse.htmlToText("a<b"));
        ParseTest.assertEquals((String)"a\nb\nc\nd", (String)Parse.htmlToText("a<br>b<br/>c<  br   /   >d"));
        ParseTest.assertEquals((String)"a\nb", (String)Parse.htmlToText("a</p><p>b"));
        ParseTest.assertEquals((String)"a\nb", (String)Parse.htmlToText("a< / p >   <   p  >b"));
    }

    public void testUnescape() {
        ParseTest.assertEquals((String)"a<b", (String)Parse.unescape("a&lt;b"));
        ParseTest.assertEquals((String)"a>b & b>c &&", (String)Parse.unescape("a&gt;b&nbsp;&amp;&nbsp;b>c &&"));
        ParseTest.assertEquals((String)"&amp;&amp;", (String)Parse.unescape("&amp;amp;&amp;amp;"));
        ParseTest.assertEquals((String)"a>b & b>c &&", (String)Parse.unescape("a&gt;b&nbsp;&amp;&nbsp;b>c &&"));
        ParseTest.assertEquals((String)"\"\"'", (String)Parse.unescape("\u201c\u201d\u2019"));
    }

    public void testWhitespaceIsCondensed() {
        ParseTest.assertEquals((String)"a b", (String)Parse.condenseWhitespace(" a  b  "));
        ParseTest.assertEquals((String)"a b", (String)Parse.condenseWhitespace(" a  \n\tb  "));
        ParseTest.assertEquals((String)"", (String)Parse.condenseWhitespace(" "));
        ParseTest.assertEquals((String)"", (String)Parse.condenseWhitespace("  "));
        ParseTest.assertEquals((String)"", (String)Parse.condenseWhitespace("   "));
        ParseTest.assertEquals((String)"", (String)Parse.condenseWhitespace(new String(new char[]{'\u00a0'})));
    }
}

