import jnb.Account;
import jnb.Customer;
import jnb.Money;

import java.util.*;

public class CustomersAccountList extends fit.RowFixture {
    public Object[] query() throws Exception
    {
        final List customers = TestBank.systemUnderTest.bank.getCustomers();

        return getBankAccounts(customers);

    }

    protected Object[] getBankAccounts(final List customers)
    {
        List bankAccounts = new ArrayList();
        for(Iterator iter = customers.iterator(); iter.hasNext(); ) {
            Customer customer = (Customer) iter.next();
            final Collection accounts = customer.getAccounts();
            for(Iterator accountsIter = accounts.iterator(); accountsIter.hasNext(); ) {
                final BankAccount bankAccount = new BankAccount((Account)accountsIter.next());
                bankAccounts.add(bankAccount);
            }
        }

        return bankAccounts.toArray();
    }

    public Class getTargetClass()
    {
        return BankAccount.class;
    }

    public Object parse(String s, Class type) throws Exception
    {
        if (Money.class.isAssignableFrom(type)) {
            return new Money(s);
        } else if (Customer.class.isAssignableFrom(type)) {
            return new Customer(s);
        }
        return super.parse(s, type);
    }

    public static class BankAccount {
        public final String id;
        public final Customer customer;
        public final Money balance;

        public BankAccount(Account account)
        {
            this.id = account.getId();
            this.customer = account.getCustomer();
            this.balance = account.getBalance();
        }
    }
}
