package jnb;

import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Bank {
    private List customers = new ArrayList();

    public List getCustomers()
    {
        return Collections.unmodifiableList(customers);
    }

    public Customer addNewCustomer(String customerName) {
        Customer customer = new Customer(customerName);
        customers.add(customer);
        return customer;
    }

    public void addCustomerAccount(Customer customer, String accountID, Money startingBalance) {
        customer.addAccount(new Account(accountID, customer, startingBalance));
    }

    public List getCustomers(String customerName) {
        List customerMatchList = new ArrayList();
        for(Iterator iter = customers.iterator(); iter.hasNext(); ) {
            Customer customer = (Customer) iter.next();
            if (customer.getName().equals(customerName)) {
                customerMatchList.add(customer);
            }
        }
        return Collections.unmodifiableList(customerMatchList);
    }
}
