import fit.FileRunner;

import java.io.File;
import java.io.IOException;

public class DirectoryRunner {
    public static void main(String[] args) throws Exception
    {
        File inputDirectory = new File(args[0]);
        File outputDirectory = new File(args[1]);
        if (!directoryExists(inputDirectory) || !directoryExists(outputDirectory)) {
            return;
        }

        runTestsInDirectory(inputDirectory, outputDirectory);
    }

    private static boolean directoryExists(File directory) {
        if (!directory.exists()) {
            System.err.println(directory.getPath() + " does not exist");
            return false;
        }
        return true;
    }

    private static void runTestsInDirectory(File inputDirectory, File outputDirectory)
    {
        File[] files = inputDirectory.listFiles();
        for (int i = 0; i < files.length; i++) {
            final File file = files[i];
            if (file.isFile()) {
                MyFileRunner.main(new String[]
                {
                    file.getPath(),
                    new File(outputDirectory, file.getName()).getPath()
                });
            } else if (file.isDirectory()) {
                File childOutputDirectory = getChildDirectory(new File(outputDirectory, file.getName()));
                runTestsInDirectory(file, childOutputDirectory);
            }
        }
    }

    private static File getChildDirectory(File directory)
    {
        if (!directory.exists()) {
            directory.mkdir();
        }
        return directory;
    }

    private static class MyFileRunner extends FileRunner {
        public static void main(String[] args) {
            try {
                new MyFileRunner().run(args);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        //Override parent exit because it kills the VM :-(
        protected void exit()
        {
            output.close();
            System.err.println(fixture.counts());
        }
    }
}