import fit.ColumnFixture;
import jnb.Money;
import jnb.Customer;
import jnb.Account;

public abstract class CustomerAccountMoney extends ColumnFixture {
    public Customer customer;
    public Account account;
    public Money amount;

    public Money balance() {
        return account.getBalance();
    }

    public Object parse(String s, Class type) throws Exception
    {
        if (Customer.class.isAssignableFrom(type)) {
            return TestBank.systemUnderTest.bank.getCustomers(s).get(0);
        } else if (Account.class.isAssignableFrom(type)) {
            return customer.getAccount(s);
        } else if (Money.class.isAssignableFrom(type)) {
            return new Money(s);
        }
        return super.parse(s, type);
    }
}
