import fit.Fixture;
import jnb.*;

import java.util.Collection;
import java.util.List;

public class CustomerBankingActions extends Fixture {
    private Bank systemUnderTest;
    private Customer customer;
    private String accountID;
    private Money startingBalance;
    private Account transferFromAccount;
    private Account transferToAccount;
    private Money transferAmount;

    public void customer(String customerName) {
        this.customer = getCustomer(customerName);
    }

    private Customer getCustomer(String customerName) {
        final Bank bank = getSystemUnderTest();
        final List customerList = bank.getCustomers(customerName);
        if (customerList.size() == 0) {
            return bank.addNewCustomer(customerName);
        }
        return (Customer)customerList.get(0);
    }

    public Account[] accounts() {
        final Collection accounts = customer.getAccounts();
        return (Account[])accounts.toArray(new Account[accounts.size()]);
    }

    public void account(String accountID) {
        this.accountID = accountID;
    }

    public void startingBalance(Money money) {
        this.startingBalance = money;
    }

    public void createAccount() {
        this.getSystemUnderTest().addCustomerAccount(customer, accountID, startingBalance);
    }

    public Money customerTotalBalance() {
        return this.customer.getBalance();
    }

    public Object parse(String s, Class type) throws Exception {
        if (Account.class.isAssignableFrom(type)) {
            return customer.getAccount(s);
        } else if (Money.class.isAssignableFrom(type)) {
            return new Money(s);
        }
        return super.parse(s, type);
    }

    private Bank getSystemUnderTest() {
        if (systemUnderTest == null) {
            systemUnderTest = TestBank.systemUnderTest == null ? new Bank() : TestBank.systemUnderTest.bank;
        }
        return systemUnderTest;
    }

    public void transferFrom(Account transferFrom) {
        this.transferFromAccount = transferFrom;
    }

    public void transferTo(Account transferTo) {
        this.transferToAccount = transferTo;
    }

    public void transferAmount(Money amount) {
        this.transferAmount = amount;
    }

    public void transactTransfer() throws InsufficientFundsException, InvalidTransactionException {
        this.transferToAccount.transferFunds(transferFromAccount, transferAmount);
    }
}
