using System;
using System.Collections.Generic;
using System.Reactive.Linq;
using SensorEventLib;
using System.Reactive.Subjects;
using System.Threading;

namespace ReactiveDDS
{
    class ReactiveDDS
    {
        static void Main(string[] args)
        {
            try
            {
                var obsGroup = new Subject<Subject<SensorEventArgs>>();
                var sevp = new SensorEventPublisherSubject(args, obsGroup);

                var waitHandle = new EventWaitHandle(false, EventResetMode.AutoReset);

                using (obsGroup.Subscribe(obs => obs.Subscribe(
                    Console.WriteLine,
                    () =>
                    {
                        System.Console.WriteLine("Completed");
                        waitHandle.Set();
                    })))
                {
                    sevp.Run();

                    bool signaled = false;
                    do
                    {
                        signaled = waitHandle.WaitOne(TimeSpan.FromSeconds(1));
                    } while (!signaled);

                    sevp.Stop();
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
        }
    }
}



