using System;
using System.Reactive.Linq;
using SensorEventLib;

namespace ReactiveDDS
{
    class ReactiveDDS
    {
        static void Main(string[] args)
        {
            try
            {
                var sevp = new SensorEventPublisher(args);

                var obs = Observable.FromEventPattern<SensorEventArgs>(
                    eh => sevp.SensorEvent += eh,
                    eh => sevp.SensorEvent -= eh)
                    .Select(e => e.EventArgs);

                // obs is IObservable<SensorEventArgs>
                using (obs.Subscribe(Console.WriteLine))
                {
                    sevp.Run();
                    Console.WriteLine("Press ENTER to stop");
                    Console.ReadLine();
                    sevp.Stop();
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
        }
    }
}



