#include "../SensorIDL/SensorTypeSupportC.h"
#include "../SensorIDL/SensorC.h"
#include "../SensorIDL/SensorTypeSupportImpl.h"
#include "../SensorIDL/DDSException.h"
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/Service_Participant.h>
#include <ace/OS.h>
#include <thread>

int main(int argc, char *argv[]) {
	DDS::DomainParticipantFactory_var dpf;
	DDS::DomainParticipant_var dp;
	try {
		dpf = TheParticipantFactoryWithArgs(argc, argv);
		dp = dpf->create_participant(42, PARTICIPANT_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
		if (0 == dp) 
			throw DDSException("create_participant() failed");

		Sensor::SensorDataTypeSupport_var ts = new Sensor::SensorDataTypeSupportImpl();
		if (ts->register_type(dp, "") != DDS::RETCODE_OK)
			throw DDSException("reigster_type() failed");

		// CORBA::String_var typeName(ts->get_type_name());
		DDS::Topic_var topic = dp->create_topic("Temperature", ts->get_type_name(), TOPIC_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
		if (0 == topic)
			throw DDSException("create_topic() failed");

		DDS::Publisher_var pub = dp->create_publisher(PUBLISHER_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
		if (0 == pub)
			throw DDSException("create_publisher() failed");

		DDS::DataWriterQos dw_qos;
		pub->get_default_datawriter_qos(dw_qos);
		DDS::DataWriter_var dw = pub->create_datawriter(topic, dw_qos, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
		if (0 == dw)
			throw DDSException("create_datawriter() failed");

		Sensor::SensorDataDataWriter_var sdw = Sensor::SensorDataDataWriter::_narrow(dw);
		if (0 == sdw)
			throw DDSException("writer _narrow() failed");

		// publish
		Sensor::SensorData sample;
		sample.sensorID = "Temp7";
		time_t sampleDate;
		for (int i = 0; i < 20; i++) {
			time(&sampleDate);  // seconds since midnight 1/1/1970 UTC
			sample.date = sampleDate;
			sample.reading = i%10;

			// std::cout << "Publishing: " << sample.date << " " << sample.reading << std::endl;

			if (sdw->write(sample, DDS::HANDLE_NIL) != DDS::RETCODE_OK)
				throw DDSException("sample write() failed");

			// sleep for 2 seconds
			std::this_thread::sleep_for(std::chrono::milliseconds(2000));
		}

	} catch (const std::exception &e) {
		std::cout << "SensorPublisher exception (main): " << e.what() << std::endl;
		return -1;
	} catch (const CORBA::Exception &e) {
		e._tao_print_exception("SensorPublisher exception (main): ");
		return -1;
	} 

	if (0 != dp)
		dp->delete_contained_entities();
	if (0 != dpf)
		dpf->delete_participant(dp);

	TheServiceParticipant->shutdown();

	return 0;
}
