package com.ociweb;

import org.omg.CORBA.StringSeqHolder;
import rx.subjects.BehaviorSubject;
import DDS.*;
import OpenDDS.DCPS.*;
import Sensor.*;
import rx.subjects.*;
import rx.functions.Action1;
import rx.functions.Action0;

public class ReactiveDDSJ {
	public static void main(String[] args) {
		DomainParticipantFactory dpf = TheParticipantFactory
				.WithArgs(new StringSeqHolder(args));
		if (dpf == null) {
			System.err.println("Domain Participant Factory not found");
			return;
		}

		DomainParticipant dp = dpf.create_participant(42,
				PARTICIPANT_QOS_DEFAULT.get(), null, DEFAULT_STATUS_MASK.value);
		if (dp == null) {
			System.err.println("Domain Participant creation failed");
			return;
		}

		SensorDataTypeSupportImpl servant = new SensorDataTypeSupportImpl();
		if (servant.register_type(dp, "") != RETCODE_OK.value) {
			System.err.println("register_type failed");
			return;
		}

		Topic top = dp.create_topic("Temperature", servant.get_type_name(),
				TOPIC_QOS_DEFAULT.get(), null, DEFAULT_STATUS_MASK.value);
		if (top == null) {
			System.err.println("ERROR: Topic creation failed");
			return;
		}

		Subscriber sub = dp.create_subscriber(SUBSCRIBER_QOS_DEFAULT.get(),
				null, DEFAULT_STATUS_MASK.value);
		if (sub == null) {
			System.err.println("ERROR: Subscriber creation failed");
			return;
		}

		// PublishSubject since only want what is emitted by the source (no default values as with BehaviorSubject)
		// https://github.com/ReactiveX/RxJava/wiki/Subject
        PublishSubject<PublishSubject<SensorData>> obsGroup = PublishSubject.create();
        
		DataReaderListenerImpl listener = new DataReaderListenerImpl(obsGroup);
		DataReader dr = sub.create_datareader(top, DATAREADER_QOS_DEFAULT.get(), listener,
				DEFAULT_STATUS_MASK.value);
		if (dr == null) {
			System.err.println("ERROR: DataReader creation failed");
			return;
		}

		/*
		// nicer with Java 8 lambdas:  http://bl.ocks.org/benjchristensen/4965520
		// o.date is seconds since epoch, but Date constructor takes milliseconds since epoch
		obsGroup.subscribe(new Action1<PublishSubject<SensorData>>() {
            @Override
            public void call(PublishSubject<SensorData> obs) {
            	obs.subscribe(
            		new Action1<SensorData>() {
	                    @Override
	                    public void call(SensorData sd) {
	                        System.out.println("[" + sd.sensorID + " " + new java.util.Date(sd.date*1000) + " " + sd.reading + "]");
	                    }
            		}, new Action1<Throwable>() {
	                    @Override
	                    public void call(Throwable error) {
	                        // no action, but handler can't be null
	                    }
	                }, new Action0() {
	                    @Override
	                    public void call() {
	                        System.out.println("Completed");
	                    }
	                });
            }
        });
        */
		
		obsGroup.subscribe((obs) -> {
			obs.subscribe(
				(sd) -> { System.out.println("[" + sd.sensorID + " " + new java.util.Date(sd.date*1000) + " " + sd.reading + "]"); },
				(ex) -> {},
				() -> { System.out.println("Completed"); }
				);
			});
		
	

		
		StatusCondition sc = dr.get_statuscondition();
		sc.set_enabled_statuses(SUBSCRIPTION_MATCHED_STATUS.value);
		WaitSet ws = new WaitSet();
		ws.attach_condition(sc);
		SubscriptionMatchedStatusHolder matched = new SubscriptionMatchedStatusHolder(
				new SubscriptionMatchedStatus());
		Duration_t timeout = new Duration_t(DURATION_INFINITE_SEC.value,
				DURATION_INFINITE_NSEC.value);

		boolean matched_pub = false;
		while (true) {
			final int result = dr.get_subscription_matched_status(matched);
			if (result != RETCODE_OK.value) {
				System.err.println("ERROR: get_subscription_matched_status()"
						+ "failed.");
				return;
			}

			if (matched.value.current_count == 0
					&& matched.value.total_count > 0) {
				break;
			} else if (matched.value.current_count > 0 && !matched_pub) {
				matched_pub = true;
			}

			ConditionSeqHolder cond = new ConditionSeqHolder(new Condition[] {});
			if (ws.wait(cond, timeout) != RETCODE_OK.value) {
				System.err.println("ERROR: wait() failed.");
				return;
			}
		}

		ws.detach_condition(sc);

		dp.delete_contained_entities();
		dpf.delete_participant(dp);
		TheServiceParticipant.shutdown();
	}
}
