using System;

namespace SensorEventLib
{
    // Albahari C# 5, p 130
    public class SensorEventArgs : EventArgs, IEquatable<SensorEventArgs>
    {
        public readonly string SensorID;
        public readonly DateTime Date;
        public readonly double Reading;

        public SensorEventArgs(string sensorID, DateTime date, double reading)
        {
            SensorID = sensorID;
            Date = date;
            Reading = reading;
        }

        public override string ToString()
        {
            // Date is in UTC, so convert to local time for display
            return "[" + SensorID + ", " + Date.ToLocalTime() + ", " + Reading + "]";
        }

        // since results.Messages.AssertEqual() uses the default comparator, obtained from IEquatable<>, implement this
        public bool Equals(SensorEventArgs other)
        {
            return SensorID.Equals(other.SensorID) && Date.Equals(other.Date) && NearlyEqual(Reading, other.Reading, 0.00001);
        }

        // http://stackoverflow.com/questions/3874627/floating-point-comparison-functions-for-c-sharp
        public bool NearlyEqual(double a, double b, double epsilon)
        {
            double absA = Math.Abs(a);
            double absB = Math.Abs(b);
            double diff = Math.Abs(a - b);

            if (a == b)
            { 
                // shortcut, handles infinities
                return true;
            }
            else if (a == 0 || b == 0 || diff < Double.MinValue)
            {
                // a or b is zero or both are extremely close to it
                // relative error is less meaningful here
                return diff < (epsilon * Double.MinValue);
            }
            else
            { 
                // use relative error
                return diff / (absA + absB) < epsilon;
            }
        }
    }
}