name := "parse"

version := "0.1.0"

resolvers += "typesafe" at "http://repo.typesafe.com/typesafe/releases"

libraryDependencies ++= Seq(
	// https://github.com/scala/scala-parser-combinators
	"org.scala-lang.modules" %% "scala-parser-combinators" % "1.0.4",
	// https://etorreborre.github.io/specs2/guide/SPECS2-3.6.6/org.specs2.guide.Installation.html
    "org.specs2" %% "specs2-core" % "3.6.6" % "test",
    "org.specs2" %% "specs2-junit" % "3.6.6" % "test",
    "org.specs2" %% "specs2-matcher-extra" % "3.6.6" % "test",
    // https://github.com/scodec/scodec - http://scodec.org/releases/
    "org.scodec" %% "scodec-core" % "1.8.3",
    "org.scodec" %% "scodec-bits" % "1.0.12"
)

// http://scodec.org/releases/
libraryDependencies ++= {
  if (scalaBinaryVersion.value startsWith "2.10")
    Seq(compilerPlugin("org.scalamacros" % "paradise" % "2.0.1" cross CrossVersion.full))
  else Nil
}

exportJars := true

scalacOptions ++= Seq("-encoding", "UTF-8", "-Xlint", "-deprecation", "-unchecked", "-feature", "-Yrangepos")

scalaVersion := "2.11.7"
